<?php
date_default_timezone_set("Asia/Taipei");
/*
##########################################################################
#                      PHP Benchmark Performance Script                  #
#                         ?2010 Code24 BV                                # 
#                                                                        #
#  Author      : Alessandro Torrisi                                      #
#  Company     : Code24 BV, The Netherlands                              #
#  Date        : July 31, 2010                                           #
#  version     : 1.0                                                     #
#  License     : Creative Commons CC-BY license                          #
#  Website     : http://www.php-benchmark-script.com                     #	
#                                                                        #
##########################################################################
*/
	$pinginfo = array();
//exec("/bin/ping -v -c 1 168.95.1.1", $pinginfo);
//var_dump($pinginfo);
	function test_Math($count = 525000) {
		$time_start = microtime(true);
		$mathFunctions = array("abs", "acos", "asin", "atan", "bindec", "floor", "exp", "sin", "tan", "pi", "is_finite", "is_nan", "sqrt");
		foreach ($mathFunctions as $key => $function) {
			if (!function_exists($function)) unset($mathFunctions[$key]);
		}
		for ($i=0; $i < $count; $i++) {
			foreach ($mathFunctions as $function) {
				$r = call_user_func_array($function, array($i));
			}
		}
		return number_format(microtime(true) - $time_start, 3);
	}
	
	
	function test_StringManipulation($count = 487500) {
		$time_start = microtime(true);
		$stringFunctions = array("addslashes", "chunk_split", "metaphone", "strip_tags", "md5", "sha1", "strtoupper", "strtolower", "strrev", "strlen", "soundex", "ord");
		foreach ($stringFunctions as $key => $function) {
			if (!function_exists($function)) unset($stringFunctions[$key]);
		}
		$string = "the quick brown fox jumps over the lazy dog";
		for ($i=0; $i < $count; $i++) {
			foreach ($stringFunctions as $function) {
				$r = call_user_func_array($function, array($string));
			}
		}
		return number_format(microtime(true) - $time_start, 3);
	}


	function test_Loops($count = 71250000) {
		$time_start = microtime(true);
		for($i = 0; $i < $count; ++$i);
		$i = 0; while($i < $count) ++$i;
		return number_format(microtime(true) - $time_start, 3);
	}

	
	function test_IfElse($count = 33750000) {
		$time_start = microtime(true);
		for ($i=0; $i < $count; $i++) {
			if ($i == -1) {
			} elseif ($i == -2) {
			} else if ($i == -3) {
			}
		}
		return number_format(microtime(true) - $time_start, 3);
	}	
	
	
	$total = 0;
	$functions = get_defined_functions();
	$line = str_pad("-",38,"-");
	echo "<html xmlns=http://www.w3.org/1999/xhtml xml:lang=zh-tw lang=zh-tw><head><meta http-equiv=content-type content=text/html; charset=utf-8 /></head><pre>$line\n|".str_pad("PHP 主機 CPU 處理速度測試",36," ",STR_PAD_BOTH)."|\n$line\n開始 : ".date("Y-m-d H:i:s")."\n伺服器 : {$_SERVER['SERVER_ADDR']}\nPHP 版本 : ".PHP_VERSION."\n系統平台 : ".PHP_OS. "\n$line\n";
	foreach ($functions['user'] as $user) {
		if (preg_match('/^test_/', $user)) {
			$total += $result = $user();
            echo str_pad($user, 25) . " : " . $result ." 秒.\n";
        }
	}
	echo str_pad("-", 38, "-") . "\n" . str_pad("總花費時間(數字越小越快)", 25) . " : " . $total ." 秒.\n".$pinginfo[5]."</pre>";

?>